const API_BASE = "https://f015bd15-bb56-4181-9183-b205965df48a-00-2u4ar3nqv01jk.pike.replit.dev";
const resultArea = document.getElementById("resultArea");
const searchInput = document.getElementById("searchInput");
const searchBtn = document.getElementById("searchBtn");

document.addEventListener("DOMContentLoaded", () => {
  chrome.storage.local.get("lastCheckedDomain", (data) => {
    if (data.lastCheckedDomain) {
      searchInput.value = data.lastCheckedDomain;
      checkCasino(data.lastCheckedDomain);
      chrome.storage.local.remove("lastCheckedDomain");
    }
  });

  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    if (tabs[0] && tabs[0].url && !searchInput.value) {
      try {
        const domain = new URL(tabs[0].url).hostname.replace("www.", "");
        if (domain && !domain.includes("chrome") && !domain.includes("newtab")) {
          searchInput.value = domain;
        }
      } catch (e) {}
    }
  });
});

searchBtn.addEventListener("click", () => {
  const query = searchInput.value.trim();
  if (query) checkCasino(query);
});

searchInput.addEventListener("keypress", (e) => {
  if (e.key === "Enter") {
    const query = searchInput.value.trim();
    if (query) checkCasino(query);
  }
});

function checkCasino(query) {
  resultArea.innerHTML = `
    <div class="loading">
      <div class="spinner"></div>
      Scanning "${query}"...
    </div>`;

  fetch(`${API_BASE}/api/casino-check?domain=${encodeURIComponent(query)}`)
    .then(res => res.json())
    .then(data => renderResult(data))
    .catch(err => {
      resultArea.innerHTML = `
        <div class="status-card status-unknown">
          <div class="status-badge badge-unknown">CONNECTION ERROR</div>
          <p class="details">Could not reach WagerX servers. Check your connection and try again.</p>
        </div>`;
    });
}

function renderResult(data) {
  if (data.found_in_wagerx && data.casino) {
    const casino = data.casino;
    const rec = data.recommendation;
    const statusClass = rec === "safe" ? "status-safe" : rec === "caution" ? "status-caution" : "status-warning";
    const badgeClass = rec === "safe" ? "badge-safe" : rec === "caution" ? "badge-caution" : "badge-warning";
    const badgeText = rec === "safe" ? "VERIFIED SAFE" : rec === "caution" ? "USE CAUTION" : "WARNING";

    let html = `
      <div class="status-card ${statusClass}">
        <div class="status-badge ${badgeClass}">${badgeText}</div>
        <div class="casino-name">${casino.name}</div>
        <div class="score">Trust Score: <strong>${casino.score}/10</strong> — ${casino.tag}</div>
        <div class="details">
          <strong>Status:</strong> ${casino.status}<br>
          <strong>Notes:</strong> ${casino.notes}<br>
          <strong>Live Test:</strong> ${casino.live_test}
        </div>
      </div>`;

    if (data.community_intel) {
      const ci = data.community_intel;
      html += `
        <div class="community-section">
          <h3>Community Intel (Bitcointalk)</h3>
          <div class="community-stat">
            <span class="stat-pos">${ci.positive} positive reports</span>
            <span class="stat-neg">${ci.negative} negative reports</span>
          </div>
        </div>`;
    }

    html += `<div class="disclaimer">Data from WagerX live audits with real deposits & withdrawals. Community reports are unverified.</div>`;
    resultArea.innerHTML = html;

  } else {
    let html = `
      <div class="not-audited">
        <div class="icon">🔍</div>
        <div class="casino-name" style="font-size:14px;margin-bottom:8px;">"${data.query}" not found in WagerX database</div>
        <p>This casino hasn't been audited by WagerX yet. We recommend playing only at verified casinos.</p>
      </div>`;

    if (data.community_intel) {
      const ci = data.community_intel;
      html += `
        <div class="community-section">
          <h3>Community Intel (Bitcointalk)</h3>
          <div class="community-stat">
            <span class="stat-pos">${ci.positive} positive</span>
            <span class="stat-neg">${ci.negative} negative</span>
          </div>
          <div class="disclaimer" style="margin-top:6px;">Community reports are unverified user claims.</div>
        </div>`;
    }

    resultArea.innerHTML = html;
  }
}
