const API_BASE = "https://f015bd15-bb56-4181-9183-b205965df48a-00-2u4ar3nqv01jk.pike.replit.dev";

chrome.runtime.onInstalled.addListener(() => {
  chrome.contextMenus.create({
    id: "wagerx-check",
    title: "Ask Wagie: Is this casino safe?",
    contexts: ["page", "link"]
  });
});

chrome.contextMenus.onClicked.addListener((info, tab) => {
  if (info.menuItemId === "wagerx-check") {
    const url = info.linkUrl || info.pageUrl || "";
    let domain = "";
    try {
      domain = new URL(url).hostname.replace("www.", "");
    } catch (e) {
      domain = url;
    }

    chrome.storage.local.set({ lastCheckedDomain: domain });

    chrome.action.openPopup();
  }
});

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "checkCasino") {
    const query = request.domain || request.name || "";
    fetch(`${API_BASE}/api/casino-check?domain=${encodeURIComponent(query)}`)
      .then(res => res.json())
      .then(data => sendResponse({ success: true, data }))
      .catch(err => sendResponse({ success: false, error: err.message }));
    return true;
  }
});
